# StyleSeat - Beauty & Wellness Professional Marketplace

A production-ready, multi-platform SaaS web application for the beauty and wellness industry, built with Laravel 11, Tailwind CSS, Firebase Authentication, and Stripe Payments.

## Table of Contents

- [Features](#features)
- [Tech Stack](#tech-stack)
- [Installation](#installation)
- [Configuration](#configuration)
- [Database Setup](#database-setup)
- [Running the Application](#running-the-application)
- [cPanel Deployment](#cPanel-deployment)
- [Demo Credentials](#demo-credentials)
- [API Endpoints](#api-endpoints)
- [Project Structure](#project-structure)

## Features

### Client Features
- **Discovery & Search**: Find beauty professionals by service, city, rating, and price
- **Professional Profiles**: View detailed profiles with services, portfolio, reviews, and ratings
- **Booking System**: Multi-step booking flow with date/time selection and payment
- **Client Dashboard**: Manage upcoming/past appointments, favorites, and payment history
- **Reviews & Ratings**: Leave reviews and ratings for completed bookings
- **Payment History**: Track all transactions and payments

### Professional Features
- **Onboarding Wizard**: Set up business profile, services, availability, and payout information
- **Professional Dashboard**: Overview of bookings, revenue, and analytics
- **Calendar Management**: Manage schedule, block times, and view appointments
- **Services Management**: Create and manage services with pricing and duration
- **Client CRM**: View client information, visit history, and total spending
- **Analytics**: Track bookings and revenue over time with charts
- **Profile Settings**: Update business info, gallery, policies, and notification preferences

### Admin Features
- **Admin Dashboard**: Platform analytics with key metrics and charts
- **User Management**: Manage clients, professionals, and roles
- **Booking Management**: View and filter all bookings with export capability
- **Payment Management**: Monitor transactions, fees, and payouts
- **Global Settings**: Configure app branding, Stripe, Firebase, and email settings
- **Data Exports**: Export users, bookings, and transactions as CSV/XLSX
- **Analytics & Reports**: Sales, user, and retention analytics

### Technical Features
- **Firebase Authentication**: Email/password and Google Sign-in
- **Stripe Integration**: Payment processing with Laravel Cashier
- **Progressive Web App (PWA)**: Installable web app with service worker
- **Responsive Design**: Mobile-first Tailwind CSS styling
- **Role-Based Access Control**: Client, Professional, and Admin roles
- **Real-time Updates**: Alpine.js and Livewire for interactive UI
- **cPanel Compatible**: Ready for shared hosting deployment

## Tech Stack

### Backend
- **Framework**: Laravel 11
- **PHP**: 8.2+
- **Database**: MySQL
- **ORM**: Eloquent
- **Authentication**: Firebase Admin SDK (PHP)
- **Payments**: Stripe (via Laravel Cashier)

### Frontend
- **Templating**: Laravel Blade
- **Styling**: Tailwind CSS v3
- **Asset Building**: Vite
- **Interactivity**: Alpine.js 3, Livewire
- **Charts**: Chart.js
- **Icons**: Heroicons (via Tailwind UI)

### Deployment
- **Web Server**: Apache/Nginx (cPanel)
- **File Storage**: Local/S3 (configurable)
- **Sessions**: Database or File
- **Caching**: File or Redis (optional)

## Installation

### Prerequisites
- PHP 8.2 or higher
- Composer
- Node.js 16+ (for asset building)
- MySQL 5.7+
- Git

### Step 1: Clone Repository
```bash
git clone <repository-url>
cd styleseatApp
```

### Step 2: Install Dependencies
```bash
composer install
npm install
```

### Step 3: Environment Configuration
```bash
cp .env.example .env
php artisan key:generate
```

Edit `.env` and configure:
- **Database**: DB_HOST, DB_DATABASE, DB_USERNAME, DB_PASSWORD
- **Firebase**: FIREBASE_PROJECT_ID, FIREBASE_API_KEY, FIREBASE_CREDENTIALS_PATH
- **Stripe**: STRIPE_PUBLIC_KEY, STRIPE_SECRET_KEY, STRIPE_WEBHOOK_SECRET
- **Mail**: MAIL_MAILER, MAIL_FROM_ADDRESS, etc.

### Step 4: Setup Firebase
1. Create a Firebase project at https://firebase.google.com/console
2. Download the service account key JSON from Firebase Console
3. Save as `firebase-credentials.json` in the project root
4. Update `FIREBASE_CREDENTIALS_PATH` in `.env`

### Step 5: Configure Stripe
1. Get API keys from Stripe Dashboard
2. Update `STRIPE_PUBLIC_KEY`, `STRIPE_SECRET_KEY` in `.env`
3. Set `STRIPE_MODE=test` for testing

### Step 6: Run Migrations & Seeders
```bash
php artisan migrate
php artisan db:seed
```

This creates all tables and populates with 20+ professionals, 75 clients, and hundreds of bookings/transactions.

### Step 7: Build Frontend Assets
```bash
npm run build
```

For development with hot reload:
```bash
npm run dev
```

### Step 8: Create Storage Symlink
```bash
php artisan storage:link
```

## Database Setup

### Migrations
The following tables are automatically created:
- `users` - All users (clients, professionals, admins)
- `professional_profiles` - Professional business information
- `services` - Services offered by professionals
- `bookings` - Appointment bookings
- `reviews` - Client reviews and ratings
- `transactions` - Payment records
- `availability` - Professional weekly availability
- `blocked_times` - Professional unavailable dates/times
- `favorites` - Saved professionals by clients
- `gallery` - Professional portfolio images
- `settings` - Global app configuration

### Seeders
Run `php artisan db:seed` to populate:
- 1 Admin user (admin@styleseat.local)
- 75 Client users
- 25 Professional users with complete profiles
- 250+ Bookings across professionals
- 1000+ Transactions
- Complete availability and gallery data

## Running the Application

### Local Development
```bash
php artisan serve
```

Access at `http://localhost:8000`

### With Vite (Hot Module Replacement)
In another terminal:
```bash
npm run dev
```

### Production
```bash
php artisan config:cache
php artisan route:cache
npm run build
```

## cPanel Deployment

### Step 1: Prepare for Deployment
```bash
composer install --no-dev --optimize-autoloader
npm run build
php artisan config:cache
php artisan route:cache
```

### Step 2: Upload Files
1. Connect via SFTP/File Manager
2. Upload all files except:
   - `node_modules/`
   - `.git/`
   - `.env` (create new on server)
3. Create `storage/logs` directory if it doesn't exist

### Step 3: Server Configuration
1. Set `public/` as the document root
2. Create `.env` file with production values:
   ```bash
   APP_ENV=production
   APP_DEBUG=false
   DB_HOST=your.mysql.server
   DB_DATABASE=your_database
   DB_USERNAME=your_username
   DB_PASSWORD=your_password
   STRIPE_MODE=live
   ```

### Step 4: Set Permissions
```bash
chmod -R 755 storage bootstrap/cache
chmod -R 644 public
```

### Step 5: Setup Database
```bash
php artisan migrate --force
php artisan db:seed --force
php artisan storage:link
```

### Step 6: Configure PHP
Ensure PHP version 8.2+ and extensions:
- `php-mysql`
- `php-json`
- `php-curl`
- `php-mbstring`
- `php-xml`
- `php-gd`

### SSL Certificate
Enable HTTPS:
1. Use cPanel's AutoSSL or purchase a certificate
2. Update `APP_URL` in `.env` to use `https://`

## Demo Credentials

### Admin Account
- **Email**: admin@styleseat.local
- **Role**: Admin
- **Access**: `/admin/dashboard`

### Sample Professional
- Any user with `professional` role can access `/professional/dashboard`
- Demo professionals are automatically created during seeding

### Sample Client
- Any user with `client` role can access `/client/dashboard`
- Demo clients are automatically created during seeding

### Test Stripe Payments
Use Stripe test card numbers:
- **Visa**: 4242 4242 4242 4242
- **MasterCard**: 5555 5555 5555 4444
- **Decline**: 4000 0000 0000 0002
- **Expiry**: Any future date
- **CVC**: Any 3 digits

## API Endpoints

### Public Endpoints
- `GET /` - Home page
- `GET /search` - Search professionals
- `GET /professional/{id}` - Professional profile
- `GET /about` - About page
- `GET /contact` - Contact page

### Client Endpoints (Authenticated)
- `GET /client/dashboard` - Dashboard
- `GET /client/bookings` - My bookings
- `GET /client/favorites` - Saved professionals
- `GET /client/profile` - Profile settings
- `GET /client/payment-history` - Payment history

### Professional Endpoints
- `GET /professional/dashboard` - Dashboard
- `GET /professional/bookings` - Manage bookings
- `GET /professional/calendar` - Calendar view
- `GET /professional/services` - Manage services
- `GET /professional/clients` - Client list
- `GET /professional/settings` - Settings

### Admin Endpoints
- `GET /admin/dashboard` - Admin dashboard
- `GET /admin/users/clients` - Client list
- `GET /admin/users/professionals` - Professional list
- `GET /admin/bookings` - All bookings
- `GET /admin/transactions` - Payment transactions
- `GET /admin/settings` - Global settings

## Project Structure

```
styleseatApp/
├── app/
│   ├── Http/
│   │   ├── Controllers/       # Route controllers
│   │   ├── Middleware/        # Auth and role middleware
│   │   └── Requests/          # Form request validation
│   ├── Models/                # Eloquent models
│   ├── Policies/              # Authorization policies
│   ├── Services/              # Business logic services
│   └── ...
├── database/
│   ├── migrations/            # Database migrations
│   ├── seeders/               # Database seeders
│   └── factories/             # Model factories
├── resources/
│   ├── views/                 # Blade templates
│   │   ├── layouts/           # Layout templates
│   │   ├── client/            # Client pages
│   │   ├── professional/      # Professional pages
│   │   └── admin/             # Admin pages
│   ├── js/                    # JavaScript files
│   └── css/                   # Stylesheet files
├── routes/
│   └── web.php                # Web routes
├── config/
│   ├── services.php           # Stripe configuration
│   ├── firebase.php           # Firebase configuration
│   └── ...
├── public/                    # Web root (set as document root)
├── storage/                   # File storage
├── bootstrap/                 # Bootstrap files
├── composer.json              # PHP dependencies
├── package.json               # JavaScript dependencies
├── vite.config.js             # Vite configuration
└── tailwind.config.js         # Tailwind CSS configuration
```

## Environment Variables

Key `.env` variables to configure:

```env
# Application
APP_NAME=StyleSeat
APP_ENV=production
APP_DEBUG=false
APP_URL=https://yourdomain.com

# Database
DB_CONNECTION=mysql
DB_HOST=localhost
DB_DATABASE=styleseat_db
DB_USERNAME=root
DB_PASSWORD=secret

# Firebase
FIREBASE_PROJECT_ID=your-project
FIREBASE_API_KEY=your-key
FIREBASE_CREDENTIALS_PATH=./firebase-credentials.json

# Stripe
STRIPE_PUBLIC_KEY=pk_live_xxx
STRIPE_SECRET_KEY=sk_live_xxx
STRIPE_MODE=live

# Mail
MAIL_MAILER=smtp
MAIL_HOST=mail.yourdomain.com
MAIL_FROM_ADDRESS=noreply@yourdomain.com

# App Settings
PLATFORM_COMMISSION_PERCENTAGE=20
BOOKING_CONFIRMATION_REQUIRED=true
```

## Troubleshooting

### Storage Symlink Error
```bash
php artisan storage:link
```

### Cache Issues
```bash
php artisan cache:clear
php artisan config:clear
```

### Database Connection
Verify MySQL credentials and ensure database exists:
```bash
mysql -u username -p -e "CREATE DATABASE styleseat_db;"
```

### Firebase Token Verification
Ensure `firebase-credentials.json` is in correct location with valid credentials.

### Stripe Webhook
Configure webhook URL in Stripe dashboard:
```
https://yourdomain.com/stripe/webhook
```

## Support & Documentation

- [Laravel Documentation](https://laravel.com/docs)
- [Firebase Admin SDK](https://firebase.google.com/docs/admin/setup)
- [Stripe API Reference](https://stripe.com/docs/api)
- [Tailwind CSS Docs](https://tailwindcss.com/docs)

## License

MIT License - See LICENSE file for details

## Contributing

Pull requests are welcome. For major changes, please open an issue first to discuss proposed changes.

---

**StyleSeat v1.0** - Built for modern beauty & wellness professionals
