<?php

namespace App\Http\Controllers;

use App\Models\ProfessionalProfile;
use App\Models\Booking;
use Illuminate\Http\Request;
use Illuminate\View\View;

class SearchController extends Controller
{
    public function index(Request $request): View
    {
        $query = ProfessionalProfile::query()->where('is_published', true);

        // Filter by service category
        if ($request->filled('service')) {
            $query->whereJsonContains('specialties', $request->get('service'));
        }

        // Filter by city
        if ($request->filled('city')) {
            $query->where('city', $request->get('city'));
        }

        // Filter by price range
        if ($request->filled('min_price') || $request->filled('max_price')) {
            // Join with services table to filter by price
            $query->join('services', 'professional_profiles.id', '=', 'services.professional_id')
                ->distinct('professional_profiles.id');
            
            if ($request->filled('min_price')) {
                $query->where('services.price', '>=', $request->get('min_price'));
            }
            if ($request->filled('max_price')) {
                $query->where('services.price', '<=', $request->get('max_price'));
            }
        }

        // Filter by rating
        if ($request->filled('min_rating')) {
            $query->where('rating', '>=', $request->get('min_rating'));
        }

        // Sort
        $sortBy = $request->get('sort_by', 'rating');
        match ($sortBy) {
            'price_asc' => $query->orderBy('services.price', 'asc'),
            'price_desc' => $query->orderBy('services.price', 'desc'),
            'most_booked' => $query->orderBy('total_bookings', 'desc'),
            default => $query->orderBy('rating', 'desc'),
        };

        $professionals = $query->paginate(12);

        return view('search', [
            'professionals' => $professionals,
            'cities' => ['Dallas', 'Chicago', 'Atlanta', 'New York', 'Los Angeles', 'Houston', 'Phoenix'],
            'services' => ['Braids', 'Locs', 'Natural Hair', 'Haircut', 'Nails', 'Makeup', 'Kids', 'Color'],
        ]);
    }
}
