<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckInstallation
{
    /**
     * The URIs that should be excluded from installation check.
     *
     * @var array<int, string>
     */
    protected $except = [
        'installer*',
        'installer/*',
    ];

    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        // Skip check for installer routes
        foreach ($this->except as $except) {
            if ($request->is($except)) {
                return $next($request);
            }
        }

        // Check if installation is complete
        $installFlagPath = storage_path('installer_completed.flag');
        
        if (!file_exists($installFlagPath) && !$request->is('installer*')) {
            return redirect('/installer');
        }

        return $next($request);
    }
}
