<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Availability extends Model
{
    use HasFactory;

    protected $fillable = [
        'professional_id', 'day_of_week', 'start_time', 'end_time',
    ];

    public function professional()
    {
        return $this->belongsTo(ProfessionalProfile::class);
    }

    public static $days = [
        0 => 'Sunday',
        1 => 'Monday',
        2 => 'Tuesday',
        3 => 'Wednesday',
        4 => 'Thursday',
        5 => 'Friday',
        6 => 'Saturday',
    ];

    public function getDayName()
    {
        return self::$days[$this->day_of_week] ?? 'Unknown';
    }
}
