<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Transaction extends Model
{
    use HasFactory;

    protected $fillable = [
        'booking_id', 'client_id', 'professional_id',
        'stripe_payment_id', 'stripe_payment_intent',
        'amount', 'platform_fee', 'professional_payout',
        'currency', 'status', 'raw_payload', 'refunded_at',
    ];

    protected $casts = [
        'raw_payload' => 'array',
        'refunded_at' => 'datetime',
    ];

    public function booking()
    {
        return $this->belongsTo(Booking::class);
    }

    public function client()
    {
        return $this->belongsTo(User::class, 'client_id');
    }

    public function professional()
    {
        return $this->belongsTo(ProfessionalProfile::class);
    }

    public function isSucceeded()
    {
        return $this->status === 'succeeded';
    }

    public function isFailed()
    {
        return $this->status === 'failed';
    }

    public function isRefunded()
    {
        return $this->status === 'refunded';
    }
}
