<?php

namespace App\Services;

use App\Models\Setting;
use Stripe\StripeClient;

class StripeService
{
    protected $stripe;

    public function __construct()
    {
        $key = config('services.stripe.secret');
        $this->stripe = new StripeClient($key);
    }

    public function createPaymentIntent($amount, $currency = 'usd', $metadata = [])
    {
        return $this->stripe->paymentIntents->create([
            'amount' => intval($amount * 100), // Convert to cents
            'currency' => $currency,
            'metadata' => $metadata,
        ]);
    }

    public function confirmPayment($paymentIntentId)
    {
        return $this->stripe->paymentIntents->retrieve($paymentIntentId);
    }

    public function refundPayment($paymentIntentId, $amount = null)
    {
        $params = ['payment_intent' => $paymentIntentId];
        if ($amount) {
            $params['amount'] = intval($amount * 100);
        }
        
        return $this->stripe->refunds->create($params);
    }

    public function createCustomer($email, $name = null)
    {
        return $this->stripe->customers->create([
            'email' => $email,
            'name' => $name,
        ]);
    }

    public function getPublicKey()
    {
        return config('services.stripe.public');
    }
}
