<?php

namespace Database\Factories;

use App\Models\ProfessionalProfile;
use Illuminate\Database\Eloquent\Factories\Factory;

class ProfessionalProfileFactory extends Factory
{
    protected $model = ProfessionalProfile::class;

    public function definition(): array
    {
        $services = ['Braids', 'Locs', 'Natural Hair', 'Haircut', 'Nails', 'Makeup', 'Kids', 'Color'];
        
        return [
            'business_name' => $this->faker->company() . ' Salon',
            'bio' => $this->faker->text(200),
            'city' => $this->faker->randomElement(['Dallas', 'Chicago', 'Atlanta', 'New York', 'Los Angeles', 'Houston', 'Phoenix']),
            'address' => $this->faker->address(),
            'phone' => $this->faker->phoneNumber(),
            'stripe_account_id' => 'acct_' . $this->faker->numerify('####################'),
            'rating' => $this->faker->randomFloat(2, 3.5, 5.0),
            'total_bookings' => $this->faker->numberBetween(10, 200),
            'total_revenue' => $this->faker->randomFloat(2, 100, 10000),
            'is_verified' => true,
            'is_published' => true,
            'specialties' => $this->faker->randomElements($services, $this->faker->numberBetween(2, 4)),
            'policies' => [
                'cancellation' => '24 hours notice required',
                'no_show_fee' => 'Full service price',
            ],
        ];
    }
}
