<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('professional_profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->string('business_name');
            $table->text('bio')->nullable();
            $table->string('city');
            $table->string('address')->nullable();
            $table->string('phone')->nullable();
            $table->string('stripe_account_id')->nullable();
            $table->string('stripe_payout_method')->nullable();
            $table->decimal('rating', 3, 2)->default(5.0);
            $table->integer('total_bookings')->default(0);
            $table->decimal('total_revenue', 10, 2)->default(0);
            $table->boolean('is_verified')->default(false);
            $table->boolean('is_published')->default(false);
            $table->json('specialties')->nullable();
            $table->json('policies')->nullable();
            $table->timestamps();
            
            $table->index('city');
            $table->index('is_published');
            $table->index('rating');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('professional_profiles');
    }
};
