@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <div class="grid grid-cols-1 lg:grid-cols-4 gap-6 mb-8">
        <!-- Stats Cards -->
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-gray-500 text-sm font-medium">Total Clients</h3>
            <p class="text-4xl font-bold text-indigo-600 mt-2">{{ $totalClients }}</p>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-gray-500 text-sm font-medium">Total Professionals</h3>
            <p class="text-4xl font-bold text-blue-600 mt-2">{{ $totalProfessionals }}</p>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-gray-500 text-sm font-medium">Active Professionals</h3>
            <p class="text-4xl font-bold text-purple-600 mt-2">{{ $activeProfessionals }}</p>
        </div>
        <div class="bg-white rounded-lg shadow p-6">
            <h3 class="text-gray-500 text-sm font-medium">Total Bookings</h3>
            <p class="text-4xl font-bold text-green-600 mt-2">{{ $totalBookings }}</p>
        </div>
    </div>

    <!-- Platform Revenue -->
    <div class="bg-white rounded-lg shadow p-6 mb-8">
        <h2 class="text-2xl font-bold mb-4">Platform Revenue</h2>
        <p class="text-4xl font-bold text-green-600">${{ number_format($platformRevenue, 2) }}</p>
        <p class="text-gray-500 text-sm mt-2">Total commission collected from successful transactions</p>
    </div>

    <!-- Navigation -->
    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <div class="bg-white rounded-lg shadow p-6 hover:shadow-lg transition cursor-pointer">
            <h3 class="text-xl font-bold mb-2">👥 User Management</h3>
            <p class="text-gray-600 mb-4">Manage clients, professionals, and roles</p>
            <div class="space-y-2">
                <a href="{{ route('admin.users.clients') }}" class="block text-indigo-600 hover:underline text-sm">View Clients</a>
                <a href="{{ route('admin.users.professionals') }}" class="block text-indigo-600 hover:underline text-sm">View Professionals</a>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 hover:shadow-lg transition cursor-pointer">
            <h3 class="text-xl font-bold mb-2">📅 Booking Management</h3>
            <p class="text-gray-600 mb-4">View and manage all bookings</p>
            <div class="space-y-2">
                <a href="{{ route('admin.bookings.index') }}" class="block text-indigo-600 hover:underline text-sm">View All Bookings</a>
                <a href="{{ route('admin.bookings.export.csv') }}" class="block text-indigo-600 hover:underline text-sm">Export CSV</a>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 hover:shadow-lg transition cursor-pointer">
            <h3 class="text-xl font-bold mb-2">💳 Transactions</h3>
            <p class="text-gray-600 mb-4">Monitor payments and payouts</p>
            <div class="space-y-2">
                <a href="{{ route('admin.transactions.index') }}" class="block text-indigo-600 hover:underline text-sm">View Transactions</a>
                <a href="{{ route('admin.transactions.export.csv') }}" class="block text-indigo-600 hover:underline text-sm">Export CSV</a>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 hover:shadow-lg transition cursor-pointer">
            <h3 class="text-xl font-bold mb-2">⚙️ Settings</h3>
            <p class="text-gray-600 mb-4">Configure app, Stripe, Firebase</p>
            <div class="space-y-2">
                <a href="{{ route('admin.settings.index') }}" class="block text-indigo-600 hover:underline text-sm">Global Settings</a>
                <a href="{{ route('admin.settings.stripe') }}" class="block text-indigo-600 hover:underline text-sm">Stripe Settings</a>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 hover:shadow-lg transition cursor-pointer">
            <h3 class="text-xl font-bold mb-2">📊 Analytics</h3>
            <p class="text-gray-600 mb-4">Sales, user, and retention reports</p>
            <div class="space-y-2">
                <a href="{{ route('admin.dashboard') }}" class="block text-indigo-600 hover:underline text-sm">View Analytics</a>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 hover:shadow-lg transition cursor-pointer">
            <h3 class="text-xl font-bold mb-2">🔍 Search Users</h3>
            <p class="text-gray-600 mb-4">Find specific clients or professionals</p>
            <div class="space-y-2">
                <a href="{{ route('admin.users.search') }}" class="block text-indigo-600 hover:underline text-sm">Search</a>
            </div>
        </div>
    </div>
</div>
@endsection
