@extends('layouts.app')

@section('content')
<div class="max-w-4xl mx-auto px-4 py-12">
    <h1 class="text-4xl font-bold mb-8">Booking Confirmation</h1>
    
    <div class="bg-green-50 border border-green-200 rounded-lg p-8 mb-8">
        <div class="text-center">
            <div class="text-6xl mb-4">✅</div>
            <h2 class="text-2xl font-bold text-green-800 mb-2">Booking Confirmed!</h2>
            <p class="text-green-700">Your appointment has been successfully booked and confirmed.</p>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-8 mb-8">
        <h3 class="text-xl font-bold mb-6">Booking Details</h3>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <div>
                <h4 class="font-semibold text-gray-600 mb-4">Service Information</h4>
                <div class="space-y-3">
                    <div>
                        <p class="text-gray-500 text-sm">Service</p>
                        <p class="font-semibold">{{ $booking->service->name }}</p>
                    </div>
                    <div>
                        <p class="text-gray-500 text-sm">Professional</p>
                        <p class="font-semibold">{{ $booking->professional->business_name }}</p>
                    </div>
                    <div>
                        <p class="text-gray-500 text-sm">Booking ID</p>
                        <p class="font-mono font-semibold text-indigo-600">#{{ $booking->id }}</p>
                    </div>
                </div>
            </div>

            <div>
                <h4 class="font-semibold text-gray-600 mb-4">Date & Time</h4>
                <div class="space-y-3">
                    <div>
                        <p class="text-gray-500 text-sm">Date</p>
                        <p class="font-semibold">{{ $booking->scheduled_at->format('l, F j, Y') }}</p>
                    </div>
                    <div>
                        <p class="text-gray-500 text-sm">Time</p>
                        <p class="font-semibold">{{ $booking->scheduled_at->format('g:i A') }}</p>
                    </div>
                    <div>
                        <p class="text-gray-500 text-sm">Duration</p>
                        <p class="font-semibold">{{ $booking->duration }} minutes</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="border-t mt-8 pt-8">
            <h4 class="font-semibold text-gray-600 mb-4">Payment Summary</h4>
            <div class="flex justify-between text-lg font-bold">
                <span>Total Paid</span>
                <span class="text-green-600">${{ number_format($booking->amount, 2) }}</span>
            </div>
        </div>
    </div>

    <div class="bg-blue-50 border border-blue-200 rounded-lg p-6 mb-8">
        <h3 class="font-semibold text-blue-800 mb-2">📧 Confirmation Sent</h3>
        <p class="text-blue-700 text-sm">A confirmation email has been sent to {{ auth()->user()->email }}</p>
    </div>

    <div class="flex gap-4">
        <a href="{{ route('client.bookings') }}" class="bg-indigo-600 text-white px-6 py-3 rounded-lg hover:bg-indigo-700">
            View My Bookings
        </a>
        <a href="{{ route('search') }}" class="border border-indigo-600 text-indigo-600 px-6 py-3 rounded-lg hover:bg-indigo-50">
            Find Another Professional
        </a>
    </div>
</div>
@endsection
