@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <div class="grid grid-cols-1 lg:grid-cols-4 gap-6 mb-8">
        <!-- Sidebar -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-lg shadow p-6">
                <div class="text-center mb-6">
                    <img src="{{ auth()->user()->avatar ?? 'https://i.pravatar.cc/150' }}" alt="{{ auth()->user()->name }}" class="w-20 h-20 rounded-full mx-auto mb-4">
                    <h2 class="text-lg font-bold">{{ auth()->user()->name }}</h2>
                    <p class="text-gray-500">{{ auth()->user()->email }}</p>
                </div>
                <nav class="space-y-2">
                    <a href="{{ route('client.dashboard') }}" class="block px-4 py-2 rounded-lg {{ request()->routeIs('client.dashboard') ? 'bg-indigo-600 text-white' : 'text-gray-700 hover:bg-gray-100' }}">Dashboard</a>
                    <a href="{{ route('client.bookings') }}" class="block px-4 py-2 rounded-lg {{ request()->routeIs('client.bookings') ? 'bg-indigo-600 text-white' : 'text-gray-700 hover:bg-gray-100' }}">My Bookings</a>
                    <a href="{{ route('client.favorites') }}" class="block px-4 py-2 rounded-lg {{ request()->routeIs('client.favorites') ? 'bg-indigo-600 text-white' : 'text-gray-700 hover:bg-gray-100' }}">Favorites</a>
                    <a href="{{ route('client.payment-history') }}" class="block px-4 py-2 rounded-lg {{ request()->routeIs('client.payment-history') ? 'bg-indigo-600 text-white' : 'text-gray-700 hover:bg-gray-100' }}">Payments</a>
                    <a href="{{ route('client.profile') }}" class="block px-4 py-2 rounded-lg {{ request()->routeIs('client.profile') ? 'bg-indigo-600 text-white' : 'text-gray-700 hover:bg-gray-100' }}">Settings</a>
                </nav>
            </div>
        </div>

        <!-- Main Content -->
        <div class="lg:col-span-3">
            <!-- Welcome Card -->
            <div class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white rounded-lg shadow p-8 mb-6">
                <h1 class="text-3xl font-bold mb-2">Welcome back, {{ explode(' ', auth()->user()->name)[0] }}!</h1>
                <p class="text-indigo-100">Manage your bookings and discover new beauty professionals.</p>
            </div>

            <!-- Stats -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-500 text-sm font-medium">Upcoming Bookings</h3>
                    <p class="text-4xl font-bold text-indigo-600 mt-2">{{ $upcomingBookings->count() }}</p>
                </div>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-500 text-sm font-medium">Total Spent</h3>
                    <p class="text-4xl font-bold text-green-600 mt-2">${{ number_format($totalSpent, 2) }}</p>
                </div>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-500 text-sm font-medium">Saved Professionals</h3>
                    <p class="text-4xl font-bold text-purple-600 mt-2">{{ $favorites->count() }}</p>
                </div>
            </div>

            <!-- Upcoming Bookings -->
            <div class="bg-white rounded-lg shadow mb-8">
                <div class="border-b px-6 py-4">
                    <h2 class="text-xl font-bold">Upcoming Appointments</h2>
                </div>
                <div class="divide-y">
                    @forelse($upcomingBookings as $booking)
                        <div class="px-6 py-4 flex justify-between items-start">
                            <div>
                                <h3 class="font-semibold">{{ $booking->service->name }}</h3>
                                <p class="text-gray-600 text-sm">{{ $booking->professional->business_name }}</p>
                                <p class="text-gray-500 text-sm mt-1">
                                    📅 {{ $booking->scheduled_at->format('M d, Y') }} at {{ $booking->scheduled_at->format('g:i A') }}
                                </p>
                            </div>
                            <div class="text-right">
                                <p class="font-semibold text-lg">${{ number_format($booking->amount, 2) }}</p>
                                <span class="inline-block px-3 py-1 rounded-full text-sm font-medium
                                    {{ $booking->status === 'confirmed' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                    {{ ucfirst($booking->status) }}
                                </span>
                            </div>
                        </div>
                    @empty
                        <div class="px-6 py-8 text-center text-gray-500">
                            <p>No upcoming bookings. <a href="{{ route('search') }}" class="text-indigo-600 hover:underline">Find a professional</a></p>
                        </div>
                    @endforelse
                </div>
            </div>

            <!-- Past Bookings -->
            <div class="bg-white rounded-lg shadow">
                <div class="border-b px-6 py-4 flex justify-between items-center">
                    <h2 class="text-xl font-bold">Recent Visits</h2>
                    <a href="{{ route('client.bookings') }}" class="text-indigo-600 hover:underline text-sm">View all</a>
                </div>
                <div class="divide-y">
                    @forelse($pastBookings->take(3) as $booking)
                        <div class="px-6 py-4 flex justify-between items-start">
                            <div>
                                <h3 class="font-semibold">{{ $booking->service->name }}</h3>
                                <p class="text-gray-600 text-sm">{{ $booking->professional->business_name }}</p>
                                <p class="text-gray-500 text-sm mt-1">{{ $booking->scheduled_at->format('M d, Y') }}</p>
                            </div>
                            <div class="flex items-center space-x-3">
                                @if(!$booking->review)
                                    <a href="{{ route('booking.review', $booking->id) }}" class="text-indigo-600 hover:underline text-sm">Leave Review</a>
                                @else
                                    <span class="text-sm text-gray-500">⭐ {{ $booking->review->rating }}/5</span>
                                @endif
                            </div>
                        </div>
                    @empty
                        <div class="px-6 py-8 text-center text-gray-500">
                            <p>No past bookings yet.</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
