@extends('layouts.app')

@section('content')
<!-- Hero Section -->
<section class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            <h1 class="text-5xl font-bold mb-4">Discover & Book Local Beauty Professionals</h1>
            <p class="text-xl text-indigo-100 mb-8">Find top-rated stylists, barbers, makeup artists, and wellness experts near you.</p>
            
            <!-- Search Bar -->
            <div class="max-w-2xl mx-auto bg-white rounded-lg shadow-lg p-6">
                <form action="{{ route('search') }}" method="GET" class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <div>
                        <input type="text" name="service" placeholder="Service (e.g., Braids)" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-indigo-600" />
                    </div>
                    <div>
                        <select name="city" class="w-full px-4 py-2 border border-gray-300 rounded-lg focus:outline-none focus:border-indigo-600">
                            <option value="">Select City</option>
                            @foreach($popularCities as $city)
                                <option value="{{ $city }}">{{ $city }}</option>
                            @endforeach
                        </select>
                    </div>
                    <button type="submit" class="bg-indigo-600 text-white px-6 py-2 rounded-lg hover:bg-indigo-700 font-semibold">Search</button>
                </form>
            </div>
        </div>
    </div>
</section>

<!-- Featured Professionals -->
<section class="py-16 bg-white">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold mb-12">Top Professionals Near You</h2>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            @foreach($featuredProfessionals as $professional)
                <div class="bg-white rounded-lg shadow-md hover:shadow-xl transition overflow-hidden">
                    <div class="aspect-square bg-gray-200 relative">
                        <img src="{{ $professional->user->avatar ?? 'https://via.placeholder.com/400' }}" alt="{{ $professional->user->name }}" class="w-full h-full object-cover">
                        <span class="absolute top-2 right-2 bg-yellow-400 text-yellow-900 px-3 py-1 rounded-full text-sm font-semibold">⭐ {{ $professional->rating }}</span>
                    </div>
                    <div class="p-6">
                        <h3 class="text-xl font-bold mb-2">{{ $professional->business_name }}</h3>
                        <p class="text-gray-600 mb-2">{{ $professional->user->name }}</p>
                        <p class="text-gray-500 text-sm mb-4">{{ $professional->city }} • {{ $professional->getReviewCount() }} reviews</p>
                        <p class="text-gray-600 text-sm mb-4 line-clamp-2">{{ $professional->bio }}</p>
                        <a href="{{ route('professional.show', $professional->id) }}" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 w-full text-center block">
                            View Profile
                        </a>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</section>

<!-- Services by Category -->
<section class="py-16 bg-gray-50">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold mb-12">Find Pros by Service</h2>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4">
            @foreach($serviceCategories as $service)
                <a href="{{ route('search', ['service' => $service]) }}" class="bg-white p-6 rounded-lg shadow-md hover:shadow-lg transition text-center">
                    <h3 class="font-semibold text-lg">{{ $service }}</h3>
                </a>
            @endforeach
        </div>
    </div>
</section>

<!-- CTA for Professionals -->
<section class="bg-gradient-to-r from-purple-600 to-indigo-600 text-white py-16">
    <div class="max-w-4xl mx-auto text-center px-4">
        <h2 class="text-4xl font-bold mb-4">Are You a Beauty Professional?</h2>
        <p class="text-xl mb-8">Join thousands of professionals growing their business on StyleSeat.</p>
        <a href="#" class="bg-white text-indigo-600 px-8 py-3 rounded-lg font-semibold hover:bg-gray-100">Set Up Your Business</a>
    </div>
</section>
@endsection
