<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>StyleSeat Installer</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <style>
        .gradient-bg {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .step-indicator {
            display: flex;
            justify-content: space-between;
            margin-bottom: 2rem;
        }
        .step {
            display: flex;
            flex-direction: column;
            align-items: center;
            flex: 1;
        }
        .step-number {
            width: 2.5rem;
            height: 2.5rem;
            border-radius: 50%;
            background: #e5e7eb;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin-bottom: 0.5rem;
        }
        .step.active .step-number {
            background: #667eea;
            color: white;
        }
        .step.completed .step-number {
            background: #10b981;
            color: white;
        }
        .step-line {
            position: absolute;
            top: 1.25rem;
            left: 50%;
            right: -50%;
            height: 2px;
            background: #e5e7eb;
        }
        .step.completed .step-line {
            background: #10b981;
        }
        .loader {
            border: 4px solid #f3f4f6;
            border-top: 4px solid #667eea;
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="min-h-screen flex flex-col">
        <!-- Header -->
        <div class="gradient-bg text-white py-8">
            <div class="max-w-4xl mx-auto px-4">
                <h1 class="text-4xl font-bold mb-2">StyleSeat Installation</h1>
                <p class="text-purple-100">Complete setup in just a few steps</p>
            </div>
        </div>

        <!-- Main Content -->
        <div class="flex-1">
            <div class="max-w-4xl mx-auto px-4 py-8">
                @yield('content')
            </div>
        </div>

        <!-- Footer -->
        <div class="bg-white border-t py-4 mt-auto">
            <div class="max-w-4xl mx-auto px-4 text-center text-gray-600 text-sm">
                <p>&copy; {{ date('Y') }} StyleSeat. Professional Beauty & Wellness Marketplace.</p>
            </div>
        </div>
    </div>

    <script>
        // CSRF token for all requests
        const token = document.querySelector('meta[name="csrf-token"]')?.content || '';
        
        async function makeRequest(url, method = 'POST', data = {}) {
            try {
                const response = await fetch(url, {
                    method: method,
                    headers: {
                        'Content-Type': 'application/json',
                        'X-CSRF-TOKEN': token,
                    },
                    body: method !== 'GET' ? JSON.stringify(data) : undefined,
                });

                return await response.json();
            } catch (error) {
                return { success: false, message: error.message };
            }
        }

        function showMessage(message, type = 'info') {
            const alertDiv = document.createElement('div');
            const bgColor = type === 'success' ? 'bg-green-100' : 'bg-red-100';
            const textColor = type === 'success' ? 'text-green-800' : 'text-red-800';
            
            alertDiv.className = `${bgColor} ${textColor} p-4 rounded-lg mb-4`;
            alertDiv.textContent = message;
            
            const container = document.querySelector('.message-container') || document.querySelector('main');
            container.insertBefore(alertDiv, container.firstChild);
            
            setTimeout(() => alertDiv.remove(), 5000);
        }
    </script>

    @yield('scripts')
</body>
</html>
