@extends('installer.layout')

@section('content')
<div class="bg-white rounded-lg shadow-lg p-8">
    <h2 class="text-2xl font-bold text-gray-900 mb-2">Database Migration</h2>
    <p class="text-gray-600 mb-6">Create database tables and optionally seed test data.</p>

    <div class="message-container"></div>

    <!-- Migration Output -->
    <div class="bg-gray-900 text-gray-100 p-4 rounded-lg font-mono text-sm mb-6 h-64 overflow-y-auto border border-gray-700">
        <div id="output" class="whitespace-pre-wrap">Waiting to run migrations...</div>
    </div>

    <!-- Options -->
    <div class="bg-blue-50 border-l-4 border-blue-500 p-4 mb-6">
        <h3 class="font-semibold text-blue-900 mb-2">Options</h3>
        <label class="flex items-center">
            <input type="checkbox" id="seedData" class="w-4 h-4 text-purple-600 border-gray-300 rounded focus:ring-purple-500">
            <span class="ml-2 text-sm text-blue-900">Seed test data (creates demo users, bookings, etc.)</span>
        </label>
        <p class="text-blue-700 text-xs mt-2">Test data is useful for development and testing. You can delete it later.</p>
    </div>

    <div class="flex gap-4">
        <a href="{{ route('installer.configuration') }}" class="flex-1 bg-gray-600 hover:bg-gray-700 text-white font-bold py-3 px-4 rounded-lg text-center transition">
            ← Back
        </a>
        <button type="button" id="migrateBtn" class="flex-1 bg-purple-600 hover:bg-purple-700 text-white font-bold py-3 px-4 rounded-lg text-center transition">
            Run Migrations →
        </button>
    </div>
</div>
@endsection

@section('scripts')
<script>
let migrationsDone = false;

async function runMigrations() {
    const output = document.getElementById('output');
    output.textContent = 'Running migrations...\n';

    const result = await makeRequest('{{ route("installer.migration.run") }}', 'POST');
    
    if (result.success) {
        output.textContent += '\n✓ Migrations completed successfully!\n\n';
        output.textContent += result.output;
        migrationsDone = true;

        if (document.getElementById('seedData').checked) {
            await runSeeders();
        } else {
            document.getElementById('migrateBtn').textContent = 'Next: Create Admin User →';
            document.getElementById('migrateBtn').onclick = () => {
                window.location.href = '{{ route("installer.admin") }}';
            };
        }
    } else {
        output.textContent += '\n✗ Migration failed!\n';
        output.textContent += result.message + '\n';
        showMessage(result.message, 'error');
    }
}

async function runSeeders() {
    const output = document.getElementById('output');
    output.textContent += '\n\nRunning database seeders...\n';

    const result = await makeRequest('{{ route("installer.migration.seed") }}', 'POST', {
        seeder: 'DatabaseSeeder'
    });
    
    if (result.success) {
        output.textContent += '\n✓ Seeding completed successfully!\n\n';
        output.textContent += result.output;
        showMessage('Test data seeded successfully!', 'success');
    } else {
        output.textContent += '\n✗ Seeding failed (but migrations succeeded).\n';
        output.textContent += result.message + '\n';
        showMessage('Warning: Seeding had issues, but migrations were successful', 'error');
    }

    document.getElementById('migrateBtn').textContent = 'Next: Create Admin User →';
    document.getElementById('migrateBtn').onclick = () => {
        window.location.href = '{{ route("installer.admin") }}';
    };
}

document.getElementById('migrateBtn').addEventListener('click', runMigrations);
</script>
@endsection
