@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <div class="grid grid-cols-1 lg:grid-cols-4 gap-6">
        <!-- Sidebar -->
        <div class="lg:col-span-1">
            <div class="bg-white rounded-lg shadow p-6 sticky top-20">
                <div class="text-center mb-6">
                    <img src="{{ auth()->user()->avatar ?? 'https://i.pravatar.cc/150' }}" alt="{{ auth()->user()->name }}" class="w-20 h-20 rounded-full mx-auto mb-4">
                    <h2 class="text-lg font-bold">{{ $professional->business_name }}</h2>
                    <p class="text-gray-500 text-sm">{{ auth()->user()->name }}</p>
                    <div class="flex justify-center items-center mt-2">
                        <span class="text-yellow-400">⭐</span>
                        <span class="font-semibold ml-1">{{ $professional->rating }}</span>
                    </div>
                </div>
                <nav class="space-y-2">
                    <a href="{{ route('professional.dashboard') }}" class="block px-4 py-2 rounded-lg {{ request()->routeIs('professional.dashboard') ? 'bg-indigo-600 text-white' : 'text-gray-700 hover:bg-gray-100' }}">Dashboard</a>
                    <a href="{{ route('professional.bookings') }}" class="block px-4 py-2 rounded-lg {{ request()->routeIs('professional.bookings') ? 'bg-indigo-600 text-white' : 'text-gray-700 hover:bg-gray-100' }}">Bookings</a>
                    <a href="{{ route('professional.calendar') }}" class="block px-4 py-2 rounded-lg {{ request()->routeIs('professional.calendar') ? 'bg-indigo-600 text-white' : 'text-gray-700 hover:bg-gray-100' }}">Calendar</a>
                    <a href="{{ route('professional.services') }}" class="block px-4 py-2 rounded-lg {{ request()->routeIs('professional.services') ? 'bg-indigo-600 text-white' : 'text-gray-700 hover:bg-gray-100' }}">Services</a>
                    <a href="{{ route('professional.clients') }}" class="block px-4 py-2 rounded-lg {{ request()->routeIs('professional.clients') ? 'bg-indigo-600 text-white' : 'text-gray-700 hover:bg-gray-100' }}">Clients</a>
                    <a href="{{ route('professional.settings') }}" class="block px-4 py-2 rounded-lg {{ request()->routeIs('professional.settings') ? 'bg-indigo-600 text-white' : 'text-gray-700 hover:bg-gray-100' }}">Settings</a>
                </nav>
            </div>
        </div>

        <!-- Main Content -->
        <div class="lg:col-span-3">
            <!-- Welcome Card -->
            <div class="bg-gradient-to-r from-indigo-600 to-purple-600 text-white rounded-lg shadow p-8 mb-6">
                <h1 class="text-3xl font-bold mb-2">Welcome, {{ explode(' ', auth()->user()->name)[0] }}!</h1>
                <p class="text-indigo-100">Manage your appointments and grow your business.</p>
            </div>

            <!-- Stats -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-500 text-sm font-medium">Today's Bookings</h3>
                    <p class="text-4xl font-bold text-indigo-600 mt-2">{{ count($todayBookings) }}</p>
                </div>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-500 text-sm font-medium">This Week</h3>
                    <p class="text-4xl font-bold text-blue-600 mt-2">{{ $weeklyStats['total_bookings'] }}</p>
                </div>
                <div class="bg-white rounded-lg shadow p-6">
                    <h3 class="text-gray-500 text-sm font-medium">Monthly Revenue</h3>
                    <p class="text-4xl font-bold text-green-600 mt-2">${{ number_format(collect($monthlyRevenue)->sum('revenue'), 2) }}</p>
                </div>
            </div>

            <!-- Today's Appointments -->
            @if(count($todayBookings) > 0)
                <div class="bg-white rounded-lg shadow mb-8">
                    <div class="border-b px-6 py-4">
                        <h2 class="text-xl font-bold">Today's Appointments</h2>
                    </div>
                    <div class="divide-y">
                        @foreach($todayBookings as $booking)
                            <div class="px-6 py-4 flex justify-between items-start">
                                <div>
                                    <h3 class="font-semibold">{{ $booking->client->user->name }}</h3>
                                    <p class="text-gray-600 text-sm">{{ $booking->service->name }}</p>
                                    <p class="text-gray-500 text-sm mt-1">
                                        🕐 {{ $booking->scheduled_at->format('g:i A') }} ({{ $booking->duration }} min)
                                    </p>
                                </div>
                                <div>
                                    <span class="inline-block px-3 py-1 rounded-full text-sm font-medium {{ $booking->status === 'confirmed' ? 'bg-green-100 text-green-800' : 'bg-yellow-100 text-yellow-800' }}">
                                        {{ ucfirst($booking->status) }}
                                    </span>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endif

            <!-- Upcoming Week -->
            <div class="bg-white rounded-lg shadow">
                <div class="border-b px-6 py-4 flex justify-between items-center">
                    <h2 class="text-xl font-bold">Upcoming Week</h2>
                    <a href="{{ route('professional.bookings') }}" class="text-indigo-600 hover:underline text-sm">View all</a>
                </div>
                <div class="divide-y">
                    @forelse($upcomingBookings as $booking)
                        <div class="px-6 py-4">
                            <div class="flex justify-between items-start">
                                <div>
                                    <h3 class="font-semibold">{{ $booking->client->user->name }}</h3>
                                    <p class="text-gray-600 text-sm">{{ $booking->service->name }}</p>
                                    <p class="text-gray-500 text-sm mt-1">
                                        📅 {{ $booking->scheduled_at->format('M d') }} at {{ $booking->scheduled_at->format('g:i A') }}
                                    </p>
                                </div>
                                <span class="text-green-600 font-semibold">${{ number_format($booking->amount, 2) }}</span>
                            </div>
                        </div>
                    @empty
                        <div class="px-6 py-8 text-center text-gray-500">
                            <p>No upcoming bookings this week.</p>
                        </div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
