@extends('layouts.app')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-12">
    <div class="mb-8">
        <h1 class="text-4xl font-bold mb-4">Search Beauty & Wellness Professionals</h1>
        
        <!-- Filter Form -->
        <div class="bg-white rounded-lg shadow-md p-6 mb-8">
            <form action="{{ route('search') }}" method="GET" class="grid grid-cols-1 md:grid-cols-5 gap-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Service</label>
                    <select name="service" class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                        <option value="">All Services</option>
                        @foreach($services as $service)
                            <option value="{{ $service }}" {{ request('service') === $service ? 'selected' : '' }}>{{ $service }}</option>
                        @endforeach
                    </select>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">City</label>
                    <select name="city" class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                        <option value="">All Cities</option>
                        @foreach($cities as $city)
                            <option value="{{ $city }}" {{ request('city') === $city ? 'selected' : '' }}>{{ $city }}</option>
                        @endforeach
                    </select>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Min Rating</label>
                    <select name="min_rating" class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                        <option value="">Any</option>
                        <option value="3" {{ request('min_rating') === '3' ? 'selected' : '' }}>3+ Stars</option>
                        <option value="4" {{ request('min_rating') === '4' ? 'selected' : '' }}>4+ Stars</option>
                        <option value="4.5" {{ request('min_rating') === '4.5' ? 'selected' : '' }}>4.5+ Stars</option>
                    </select>
                </div>
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-2">Sort By</label>
                    <select name="sort_by" class="w-full px-3 py-2 border border-gray-300 rounded-lg">
                        <option value="rating" {{ request('sort_by', 'rating') === 'rating' ? 'selected' : '' }}>Rating</option>
                        <option value="most_booked" {{ request('sort_by') === 'most_booked' ? 'selected' : '' }}>Most Booked</option>
                        <option value="price_asc" {{ request('sort_by') === 'price_asc' ? 'selected' : '' }}>Price: Low to High</option>
                        <option value="price_desc" {{ request('sort_by') === 'price_desc' ? 'selected' : '' }}>Price: High to Low</option>
                    </select>
                </div>
                
                <div class="flex items-end">
                    <button type="submit" class="w-full bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 font-semibold">Search</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Results -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6 mb-8">
        @forelse($professionals as $professional)
            <div class="bg-white rounded-lg shadow-md hover:shadow-xl transition overflow-hidden">
                <div class="aspect-square bg-gray-200">
                    <img src="{{ $professional->user->avatar ?? 'https://via.placeholder.com/400' }}" alt="{{ $professional->user->name }}" class="w-full h-full object-cover">
                </div>
                <div class="p-6">
                    <div class="flex justify-between items-start mb-2">
                        <div>
                            <h3 class="text-xl font-bold">{{ $professional->business_name }}</h3>
                            <p class="text-gray-600">{{ $professional->user->name }}</p>
                        </div>
                        <span class="bg-yellow-100 text-yellow-800 px-3 py-1 rounded-full text-sm font-semibold">⭐ {{ $professional->rating }}</span>
                    </div>
                    <p class="text-gray-500 text-sm mb-2">{{ $professional->city }} • {{ $professional->getReviewCount() }} reviews</p>
                    <p class="text-gray-600 text-sm mb-4 line-clamp-2">{{ $professional->bio }}</p>
                    <a href="{{ route('professional.show', $professional->id) }}" class="bg-indigo-600 text-white px-4 py-2 rounded-lg hover:bg-indigo-700 w-full text-center block">
                        View Profile
                    </a>
                </div>
            </div>
        @empty
            <div class="col-span-full text-center py-12">
                <p class="text-gray-500 text-lg">No professionals found matching your criteria.</p>
            </div>
        @endforelse
    </div>

    <!-- Pagination -->
    @if($professionals->count())
        <div class="flex justify-center">
            {{ $professionals->links() }}
        </div>
    @endif
</div>
@endsection
